/*-
 * Copyright (c) 1997, 1998, 1999, 2000-2003
 *	Bill Paul <wpaul@windriver.com>.  All rights reserved.
 * Copyright (c) 2007 Ravikanth Gadeela(ravikanthdrdl@yahoo.com)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ravikanth.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul, THE VOICES IN HIS HEAD OR
 * THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/dev/usb/if_mosreg.h,v 1.8 2005/06/10 16:49:15 brooks Exp $
 */

/*
 * Definitions for the MOSCHIP Technologies Ltd MOS7830 to ethernet controller.
 */

#define MOS_CTRL_TIMEOUT	1000
#define MOS_RD_BMREQ		0xc0
#define MOS_WR_BMREQ		0x40
#define MOS_RD_BREQ		0x0e
#define MOS_WR_BREQ		0x0d

#define DEVICE_REV_B	0x0100
#define DEVICE_REV_C	0x0200

#define PTR_PAUSE_THRESHOLD 0
/* Mode for PHY Register in HIF_REG_13 */
#define FARADAY_PHY_ADDRESS	0x01
#define READ_OPCODE		0x40
#define WRITE_OPCODE		0x20

/* HIF Register Bit Definitions */

#define HIF_REG_14_PEND_FLAG_BIT	0x80
#define HIF_REG_14_READY_FLAG_BIT	0x40

#define	HIF_REG_15_PROMISCIOUS		(1<<0)
#define HIF_REG_15_ALLMULTICAST		(1<<1)
#define HIF_REG_15_SLEEPMODE		(1<<2)
#define HIF_REG_15_TXENABLE		(1<<3)
#define HIF_REG_15_RXENABLE		(1<<4)
#define HIF_REG_15_FULLDUPLEX_ENABLE	(1<<5)
#define HIF_REG_15_SPEED_100		(1<<6)
#define HIF_REG_15_CFG			(1<<7)

#define LINK_OK				0x0004
#define LINK_NOT_OK			0x0000
#define MOS_RESET			0x8000
#define MOS_100_10_SPEED		0x2000
#define MOS_FD_SPEED			0x0100


/* HIF_REG_XX Corresponding Index Value */

#define HIF_REG_01			0x00
#define HIF_REG_02			0x01
#define HIF_REG_03			0x02
#define HIF_REG_04			0x03
#define HIF_REG_05			0x04
#define HIF_REG_06			0x05
#define HIF_REG_07			0x06
#define HIF_REG_08			0x07
#define HIF_REG_09			0x08
#define HIF_REG_10			0x09
#define HIF_REG_11			0x0a
#define HIF_REG_12			0x0b
#define HIF_REG_13			0x0c
#define HIF_REG_14			0x0d
#define HIF_REG_15			0x0e
#define HIF_REG_16			0x0f
#define HIF_REG_17			0x10
#define HIF_REG_18			0x11
#define HIF_REG_19			0x12
#define HIF_REG_20			0x13
#define HIF_REG_21			0x14

/* REV C REGISTERS */
#define HIF_REG_22			0x15	// RX Frames dropped
#define HIF_REG_23			0x16	// used for pause threshold
#define HIF_REG_24			0x17

#define HIF_REG_PAUSE_DATA		0x1f

/*  Index For PHY Registers */
#define         PHY_CONTROL_REG_INDEX                   (00)
#define         PHY_STATUS_REG_INDEX                    (01)
#define         PHY_IDENTIFICATION1_REG_INDEX   (02)
#define         PHY_IDENTIFICATION2_REG_INDEX   (03)
#define         PHY_AUTONEGADVT_REG_INDEX               (04)
#define         PHY_AUTONEGLINK_REG_INDEX               (05)
#define         PHY_AUTONEGEXP_REG_INDEX                (06)
#define         PHY_MIRROR_REG_INDEX                    (16)
#define         PHY_INTERRUPTENABLE_REG_INDEX   (17)
#define         PHY_INTERRUPTSTATUS_REG_INDEX   (18)
#define         PHY_CONFIG_REG_INDEX                    (19)
#define         PHY_CHIPSTATUS_REG_INDEX                (20)

#define 	INTEL_PHY_ID1			0x7830
#define 	INTEL_PHY_ID2			0x0003

/* PHY register Bit definitions*/

#define     PHY_CONTROL_LOOPBACK                                (0x4000)
#define     PHY_CONTROL_SPEED100                                (0x2000)
#define     PHY_CONTROL_AUTONEG_ENABLE                          (0x1000)
#define     PHY_CONTROL_RESTART_AUTONEG                         (0x0200)
#define     PHY_CONTROL_FULLDUPLEX                              (0x0100)
#define     PHY_CONTROL_SPEED10                                 (0x0000)
#define     PHY_CONTROL_HALFDUPLEX                              (0x0000)

#define     PHY_CHIPSTATUS_REG_LINKUP_STATUS        (0x2000)
#define	    PHY_CHIPSTATUS_REG_FULLDUPLEX_ENABLE    (0x1000)
#define	    PHY_CHIPSTATUS_REG_SPEED100             (0x0800)
#define	    PHY_CHIPSTATUS_REG_AUTONEG_COMPLETE     (0x0200)

#define	   PHY_AUTONEGADVT_FdxPause                                (0x0400)
#define    PHY_AUTONEGADVT_100T4                                   (0x0200)
#define    PHY_AUTONEGADVT_Fdx100TX                                (0x0100)
#define    PHY_AUTONEGADVT_100TX                                   (0x0080)
#define    PHY_AUTONEGADVT_10TFdx                                  (0x0040)
#define    PHY_AUTONEGADVT_10T                                     (0x0020)
#define    PHY_AUTONEGADVT_ieee802_3                               (0x0001)

#define	   PHY_STATUS_REG_LINK_STATUS				   (0x0004)


#define MOS_RXCMD_PROMISC			0x0001
#define MOS_RXCMD_ALLMULTI			0x0002
#define MOS_RXCMD_UNICAST			0x0004
#define MOS_RXCMD_BROADCAST			0x0008
#define MOS_RXCMD_MULTICAST			0x0010
#define MOS_RXCMD_ENABLE			0x0080

#define MOS_NOPHY				0xE0

#define MOS_TIMEOUT		1000
#define MOS_MIN_FRAMELEN	60
#define MOS_RX_FRAMES		1
#define MOS_TX_FRAMES		1

#define MOS_CTL_READ		0x01
#define MOS_CTL_WRITE		0x02

#define MOS_CONFIG_NO		1
#define MOS_IFACE_IDX		0

/*
 * The interrupt endpoint is currently unused
 * by the ASIX part.
 */
#define MOS_ENDPT_RX		0x0
#define MOS_ENDPT_TX		0x1
#define MOS_ENDPT_INTR		0x2
#define MOS_ENDPT_MAX		0x3

struct mos_type {
	u_int16_t		mos_vid;
	u_int16_t		mos_did;
};

#define MOS_INC(x, y)		(x) = (x + 1) % y

struct mos_softc {
#if defined(__FreeBSD__)
#define GET_MII(sc) (device_get_softc((sc)->mos_miibus))
//#elif defined(__NetBSD__)
//#define GET_MII(sc) (&(sc)->mos_mii)
//#elif defined(__OpenBSD__)
//#define GET_MII(sc) (&(sc)->mos_mii)
#endif
	struct ifnet		*mos_ifp;
	device_t		mos_miibus;
	device_t		mos_dev;
	usbd_device_handle	mos_udev;
	usbd_interface_handle	mos_iface;
	int			mos_ed[MOS_ENDPT_MAX];
	usbd_pipe_handle	mos_ep[MOS_ENDPT_MAX];
	int			mos_unit;
	int			mos_if_flags;
	struct ue_cdata		mos_cdata;
	struct ue_cdata		mos_zcdata;
	struct callout_handle	mos_stat_ch;
#if __FreeBSD_version >= 500000
	struct mtx		mos_mtx;
#endif
	char			mos_dying;
	int			mos_link;
	unsigned char		mos_ipgs[3];
	unsigned char 		mos_phyaddrs[2];
	struct timeval		mos_rx_notice;
	struct usb_qdat		mos_qdat;
	
	int 			mos_devicerelnum;
	u_char			eaddr[ETHER_ADDR_LEN];
	u_int8_t		HIF_REG_15_val;
	u_int16_t		mos_tspeed;
	u_int16_t		mos_maxpacket;
	//struct ue_chain		*zue_chain;

	struct ifmedia           mos_ifmedia;
};

//#if 0
//#define	MOS_LOCK(_sc)		mtx_lock(&(_sc)->mos_mtx)
//#define	MOS_UNLOCK(_sc)		mtx_unlock(&(_sc)->mos_mtx)
//#else
#define	MOS_LOCK(_sc)
#define	MOS_UNLOCK(_sc)
//#endif
